// priority : 100
//For specific messages on updates, use the kubejs gamestage format "pgm-1.1.0" for example for 1.1.0.

//Below are the available creative items if the configuration in gamemode.json is changed.
//Players will receive a message containing those items if "limitCreativeItemRecipes" = true.
const availableCreativeItems = [
    "Creative Ability Slot",
    "Creative Blaze Cake",
    "Creative Compressed Iron Block",
    "Creative Defense Slot",
    "Creative Energy Cell (AE2)",
    "Creative Flux Efficiency Augment",
    "Creative Paste Container",
    "Creative Reclamation Chamber Augment",
    "Creative Screen",
    "Creative Soul Slot",
    "Creative Soulium Dagger",
    "Creative Storage Upgrade",
    "Creative Upgrade Slot",
    "The Creative Probe"
]
let messageForPlayer = availableCreativeItems.join("\\n")

onEvent('player.logged_in', event => {
    if (!event.player.stages.has('starting_inventory-1.2.0')) {
        event.player.stages.add('starting_inventory-1.2.0')

        //Add the pgm-1.2.0 stage in case it's a new player, for now. That way they aren't swarmed with messages on two successive logins.
        event.player.stages.add('pgm-1.2.0')

        event.getEntity().getServer().runCommandSilent("/tellraw " + event.player.getName().getString() + " {\"text\":\"Welcome to FTB Plexiglass Mountain!\",\"color\":\"yellow\"}")
        event.player.give(Item.of('ars_nouveau:source_berry_pie', 5, "{RepairCost:0,display:{Name:'{\"text\":\"Purple Plexiglass Pie\"}'}}"))
        event.player.give(Item.of('thermal:satchel', '{ItemInv:{},Mode:0}'))
        event.player.give(Item.of('akashictome:tome', '{"akashictome:data":{advancedperipherals:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"advancedperipherals:manual"}},ars_nouveau:{Count:1b,id:"ars_nouveau:worn_notebook"},botania:{Count:1b,id:"botania:lexicon"},cloudstorage:{Count:1b,id:"cloudstorage:guide_book"},immersiveengineering:{Count:1b,id:"immersiveengineering:manual"},laserio:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"laserio:laseriobook"}},littlelogistics:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"littlelogistics:guide"}},malum:{Count:1b,id:"malum:encyclopedia_arcana"},modularrouters:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"modularrouters:book"}},mysticalagriculture:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"mysticalagriculture:guide"}},occultism:{Count:1b,id:"occultism:dictionary_of_spirits"},patchouli:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"patchouli:pm_guide"}},pneumaticcraft:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"pneumaticcraft:book"}},rftoolsbase:{Count:1b,id:"rftoolsbase:manual"},simpleplanes:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"simpleplanes:planes_book"}},solcarrot:{Count:1b,id:"solcarrot:food_book"},tconstruct:{Count:1b,id:"tconstruct:materials_and_you",tag:{mantle:{book:{current_page:"tools.part_swapping"}}}},tconstruct_0:{Count:1b,id:"tconstruct:puny_smelting",tag:{"akashictome:definedMod":"tconstruct_0"}},tconstruct_1:{Count:1b,id:"tconstruct:mighty_smelting",tag:{"akashictome:definedMod":"tconstruct_1"}},tconstruct_2:{Count:1b,id:"tconstruct:tinkers_gadgetry",tag:{"akashictome:definedMod":"tconstruct_2",mantle:{book:{current_page:""}}}},tconstruct_3:{Count:1b,id:"tconstruct:fantastic_foundry",tag:{"akashictome:definedMod":"tconstruct_3"}},tconstruct_4:{Count:1b,id:"tconstruct:encyclopedia",tag:{"akashictome:definedMod":"tconstruct_4",mantle:{book:{current_page:""}}}},thermal:{Count:1b,id:"patchouli:guide_book",tag:{"patchouli:book":"thermal:guidebook"}}}}'))

        //If limited creative items are turned on, let the player know on their first login
        if (global.gamemodeFile && global.gamemodeFile.limitCreativeItemRecipes) {
            event.getEntity().getServer().runCommandSilent("/tellraw " + event.player.getName().getString() + " \[\"\",{\"text\":\"Most creative items are disabled on this server, \",\"color\":\"yellow\"},{\"text\":\"hover here\",\"color\":\"blue\",\"hoverEvent\":{\"action\":\"show_text\",\"contents\":{\"text\":\"" + messageForPlayer + "\",\"color\":\"light_purple\"}}},{\"text\":\" to see available items.\",\"color\":\"yellow\"}\]")
        }
    }
    else {
        //Version specific updates. With the changes above this will only be sent to existing players, which are the ones to inform about this.
        if (!event.player.stages.has('pgm-1.2.0')) {
            //Cloud Storage will be removed
            event.player.stages.add('pgm-1.2.0')
            event.getEntity().getServer().runCommandSilent("/tellraw " + event.player.getName().getString() + " {\"text\":\"Patch Notes 1.2.0: Cloud Storage will be permanently removed in the next update 1.3.0. Check out storage options from the Occultism mod!\",\"color\":\"red\"}")
        }
    }
})
